/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.ftbbackups.de.piegames.blockmap.world;

import com.google.gson.Gson;
import com.google.gson.TypeAdapterFactory;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.imageio.ImageIO;
import net.creeperhost.ftbbackups.de.piegames.blockmap.MinecraftDimension;
import net.creeperhost.ftbbackups.de.piegames.blockmap.renderer.RegionRenderer;
import net.creeperhost.ftbbackups.de.piegames.blockmap.repack.io.gsonfire.GsonFireBuilder;
import net.creeperhost.ftbbackups.de.piegames.blockmap.repack.io.gsonfire.annotations.Exclude;
import net.creeperhost.ftbbackups.de.piegames.blockmap.repack.io.gsonfire.annotations.ExposeMethodParam;
import net.creeperhost.ftbbackups.de.piegames.blockmap.repack.io.gsonfire.annotations.ExposeMethodResult;
import net.creeperhost.ftbbackups.de.piegames.blockmap.repack.net.dongilu.gson.GsonJava8TypeAdapterFactory;
import net.creeperhost.ftbbackups.de.piegames.blockmap.repack.org.joml.Vector2d;
import net.creeperhost.ftbbackups.de.piegames.blockmap.repack.org.joml.Vector2dc;
import net.creeperhost.ftbbackups.de.piegames.blockmap.repack.org.joml.Vector2i;
import net.creeperhost.ftbbackups.de.piegames.blockmap.repack.org.joml.Vector2ic;
import net.creeperhost.ftbbackups.de.piegames.blockmap.repack.org.joml.Vector3d;
import net.creeperhost.ftbbackups.de.piegames.blockmap.repack.org.joml.Vector3dc;
import net.creeperhost.ftbbackups.de.piegames.blockmap.repack.org.joml.Vector3i;
import net.creeperhost.ftbbackups.de.piegames.blockmap.repack.org.joml.Vector3ic;
import net.creeperhost.ftbbackups.de.piegames.blockmap.world.ChunkMetadata;
import net.creeperhost.ftbbackups.de.piegames.blockmap.world.LevelMetadata;
import net.creeperhost.ftbbackups.de.piegames.blockmap.world.Region;
import net.creeperhost.ftbbackups.de.piegames.nbt.regionfile.RegionFile;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class RegionFolder {
    private static Logger log = LogManager.getLogger(RegionFolder.class);
    public static final Gson GSON = new GsonFireBuilder().enableExposeMethodParam().enableExposeMethodResult().enableExcludeByAnnotation().enableHooks(SavedRegionHelper.RegionHelper.class).enableHooks(LevelMetadata.MapPin.class).registerTypeSelector(Vector2ic.class, e -> Vector2i.class).registerTypeSelector(Vector3ic.class, e -> Vector3i.class).registerTypeSelector(Vector2dc.class, e -> Vector2d.class).registerTypeSelector(Vector3dc.class, e -> Vector3d.class).registerTypeSelector(ChunkMetadata.class, e -> ChunkMetadata.ChunkRenderState.valueOf((String)e.getAsJsonObject().getAsJsonPrimitive((String)"renderState").getAsString()).clazz).createGsonBuilder().registerTypeAdapterFactory((TypeAdapterFactory)new GsonJava8TypeAdapterFactory()).disableHtmlEscaping().create();

    public abstract Set<Vector2ic> listRegions();

    public abstract Region render(Vector2ic var1) throws IOException;

    public abstract long getTimestamp(Vector2ic var1) throws IOException;

    public abstract long getTimestamp();

    public abstract Optional<LevelMetadata> getPins();

    public abstract boolean needsCaching();

    public abstract boolean isNether();

    static class SavedRegionHelper {
        Collection<RegionHelper> regions;
        LevelMetadata pins;
        long timestamp;
        boolean isNether;

        public SavedRegionHelper(Collection<RegionHelper> regions, LevelMetadata pins, long timestamp, boolean isNether) {
            this.regions = regions;
            this.pins = pins;
            this.timestamp = timestamp;
            this.isNether = isNether;
        }

        static class RegionHelper {
            int x;
            int z;
            long lastModified;
            String image;
            @Exclude
            Map<? extends Vector2ic, ChunkMetadata> metadata;

            RegionHelper() {
            }

            public RegionHelper(int x, int z, long lastModified, String image, Map<? extends Vector2ic, ChunkMetadata> metadata) {
                this.x = x;
                this.z = z;
                this.lastModified = lastModified;
                this.image = image;
                this.metadata = metadata;
            }

            @ExposeMethodResult(value="metadata")
            private Collection<ChunkMetadata> postSerialize() {
                return this.metadata != null ? this.metadata.values() : Collections.emptyList();
            }

            @ExposeMethodParam(value="metadata")
            private void postDeserialize(Collection<ChunkMetadata> metadata) {
                this.metadata = Optional.ofNullable(metadata).stream().flatMap(Collection::stream).collect(Collectors.toMap(meta -> meta.position, Function.identity()));
            }
        }
    }

    public static class CachedRegionFolder
    extends LocalRegionFolder {
        protected RegionFolder world;
        protected boolean lazy;

        protected CachedRegionFolder(RegionFolder cached, boolean lazy, Path file) throws IOException {
            super(file);
            this.lazy = lazy;
            this.world = Objects.requireNonNull(cached);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Region render(Vector2ic pos) throws IOException {
            if (!this.listRegions().contains(pos)) {
                return null;
            }
            SavedRegionHelper.RegionHelper helper = (SavedRegionHelper.RegionHelper)this.regions.get(pos);
            if (helper != null && this.lazy && this.world.getTimestamp(pos) < helper.lastModified) {
                return new Region(pos, super.render(helper), helper.metadata);
            }
            Region rendered = this.world.render(pos);
            String imageName = "r." + pos.x() + "." + pos.y() + ".png";
            Path imagePath = this.getSibling((Path)this.basePath, imageName);
            ImageIO.write((RenderedImage)rendered.getImage(), "png", Files.newOutputStream(imagePath, new OpenOption[0]));
            Map map = this.regions;
            synchronized (map) {
                this.regions.put(pos, new SavedRegionHelper.RegionHelper(pos.x(), pos.y(), Files.getLastModifiedTime(imagePath, new LinkOption[0]).toMillis(), imageName, rendered.metadata));
            }
            return rendered;
        }

        @Override
        public Set<Vector2ic> listRegions() {
            return this.world.listRegions();
        }

        @Override
        public Optional<LevelMetadata> getPins() {
            return this.world.getPins();
        }

        @Override
        public long getTimestamp() {
            return this.world.getTimestamp();
        }

        @Override
        public boolean isNether() {
            return this.world.isNether();
        }

        public void filterStructures(final Set<String> allowedStructs) {
            this.regions.values().stream().flatMap(regionHelper -> regionHelper.metadata.values().stream()).forEach(metadata -> metadata.visit(new ChunkMetadata.ChunkMetadataVisitor<Void>(){

                @Override
                public Void rendered(ChunkMetadata.ChunkMetadataRendered metadata) {
                    metadata.structures.keySet().retainAll(allowedStructs);
                    return null;
                }

                @Override
                public Void failed(ChunkMetadata.ChunkMetadataFailed metadata) {
                    return null;
                }

                @Override
                public Void culled(ChunkMetadata.ChunkMetadataCulled metadata) {
                    return null;
                }

                @Override
                public Void version(ChunkMetadata.ChunkMetadataVersion metadata) {
                    return null;
                }
            }));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void save() throws IOException {
            Map map = this.regions;
            synchronized (map) {
                try (OutputStreamWriter writer = new OutputStreamWriter(new GZIPOutputStream(Files.newOutputStream((Path)this.basePath, StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING), 8192, true));){
                    GSON.toJson((Object)new SavedRegionHelper(this.regions.values(), this.getPins().orElse(null), this.getTimestamp(), this.isNether()), (Appendable)writer);
                    ((Writer)writer).flush();
                }
            }
        }

        public static CachedRegionFolder create(RegionFolder cached, boolean lazy, Path folder) throws IOException {
            Path file;
            if (!Files.exists(folder, new LinkOption[0])) {
                Files.createDirectories(folder, new FileAttribute[0]);
            }
            if (!Files.exists(file = folder.resolve("rendered.json.gz"), new LinkOption[0])) {
                try (OutputStreamWriter writer = new OutputStreamWriter(new GZIPOutputStream(Files.newOutputStream(file, StandardOpenOption.CREATE, StandardOpenOption.WRITE), 8192, true));){
                    writer.write("{regions:[]}");
                    ((Writer)writer).flush();
                }
            }
            return new CachedRegionFolder(cached, lazy, file);
        }
    }

    public static class RemoteRegionFolder
    extends SavedRegionFolder<URI> {
        public RemoteRegionFolder(URI file) throws IOException {
            super(file);
        }

        @Override
        protected InputStream getInputStream(URI path) throws IOException {
            return path.toURL().openStream();
        }

        @Override
        protected SavedRegionHelper load(URI basePath) throws IOException {
            try (InputStreamReader reader = new InputStreamReader(new GZIPInputStream(this.getInputStream(basePath), 8192));){
                SavedRegionHelper savedRegionHelper = (SavedRegionHelper)GSON.fromJson((Reader)reader, SavedRegionHelper.class);
                return savedRegionHelper;
            }
        }

        @Override
        protected URI getSibling(URI basePath, String sibling) {
            return basePath.resolve(sibling);
        }

        @Override
        public boolean needsCaching() {
            return true;
        }
    }

    public static class LocalRegionFolder
    extends SavedRegionFolder<Path> {
        public LocalRegionFolder(Path file) throws IOException {
            super(file);
        }

        @Override
        protected InputStream getInputStream(Path path) throws IOException {
            return Files.newInputStream(path, new OpenOption[0]);
        }

        @Override
        public SavedRegionHelper load(Path basePath) throws IOException {
            try (InputStreamReader reader = new InputStreamReader(new GZIPInputStream(this.getInputStream(basePath)));){
                SavedRegionHelper savedRegionHelper = (SavedRegionHelper)GSON.fromJson((Reader)reader, SavedRegionHelper.class);
                return savedRegionHelper;
            }
        }

        @Override
        protected Path getSibling(Path basePath, String sibling) {
            return basePath.resolveSibling(sibling);
        }

        @Override
        public boolean needsCaching() {
            return false;
        }

        public Path getPath(Vector2ic pos) {
            if (this.regions.containsKey(pos)) {
                return this.getSibling((Path)this.basePath, ((SavedRegionHelper.RegionHelper)this.regions.get((Object)pos)).image);
            }
            return null;
        }
    }

    public static abstract class SavedRegionFolder<T>
    extends RegionFolder {
        protected final T basePath;
        protected final Map<Vector2ic, SavedRegionHelper.RegionHelper> regions;
        protected final Optional<LevelMetadata> pins;
        protected final long timestamp;
        protected final boolean isNether;

        protected SavedRegionFolder(T file) throws IOException {
            this.basePath = file;
            SavedRegionHelper helper = this.load(file);
            if (helper == null) {
                throw new IOException("The rendered.json.gz file in the output directory is corrupt, please delete it and try again.");
            }
            this.pins = Optional.ofNullable(helper.pins);
            this.regions = Optional.ofNullable(helper.regions).stream().flatMap(Collection::stream).collect(Collectors.toMap(r -> new Vector2i(r.x, r.z), Function.identity()));
            this.timestamp = helper.timestamp;
            this.isNether = helper.isNether;
        }

        @Override
        public Region render(Vector2ic pos) throws IOException {
            SavedRegionHelper.RegionHelper helper = this.regions.get(pos);
            if (helper == null) {
                return null;
            }
            return new Region(pos, this.render(helper), helper.metadata);
        }

        protected abstract InputStream getInputStream(T var1) throws IOException;

        protected abstract T getSibling(T var1, String var2);

        protected abstract SavedRegionHelper load(T var1) throws IOException;

        protected BufferedImage render(SavedRegionHelper.RegionHelper rawRegion) throws IOException {
            return ImageIO.read(this.getInputStream(this.getSibling(this.basePath, rawRegion.image)));
        }

        @Override
        public Set<Vector2ic> listRegions() {
            return Collections.unmodifiableSet(this.regions.keySet());
        }

        @Override
        public long getTimestamp(Vector2ic pos) throws IOException {
            return this.regions.get((Object)pos).lastModified;
        }

        @Override
        public long getTimestamp() {
            return this.timestamp;
        }

        @Override
        public boolean isNether() {
            return this.isNether;
        }

        @Override
        public Optional<LevelMetadata> getPins() {
            return this.pins;
        }
    }

    public static class WorldRegionFolder
    extends RegionFolder {
        static final Pattern rfpat = Pattern.compile("^r\\.(-?\\d+)\\.(-?\\d+)\\.mca$");
        protected final Map<Vector2ic, Path> regions;
        protected final RegionRenderer renderer;
        protected LevelMetadata pins;
        protected final long timestamp;
        protected final boolean isNether;

        public WorldRegionFolder(Map<Vector2ic, Path> files, RegionRenderer renderer, boolean isNether) {
            this.regions = Objects.requireNonNull(files);
            this.renderer = Objects.requireNonNull(renderer);
            this.timestamp = System.currentTimeMillis();
            this.isNether = isNether;
        }

        @Override
        public Set<Vector2ic> listRegions() {
            return Collections.unmodifiableSet(this.regions.keySet());
        }

        @Override
        public Region render(Vector2ic pos) throws IOException {
            if (this.regions.containsKey(pos)) {
                Region region;
                Path path = this.regions.get(pos);
                RegionFile file = new RegionFile(path, StandardOpenOption.READ);
                try {
                    region = this.renderer.render(pos, file);
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            file.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (IOException | RuntimeException e) {
                        if (Files.size(path) == 0L) {
                            log.warn("'" + path + "' is empty?!");
                            return new Region(pos, new BufferedImage(512, 512, 2), new HashMap());
                        }
                        throw e;
                    }
                }
                file.close();
                return region;
            }
            return null;
        }

        @Override
        public long getTimestamp(Vector2ic pos) throws IOException {
            return Files.getLastModifiedTime(this.regions.get(pos), new LinkOption[0]).toMillis();
        }

        @Override
        public long getTimestamp() {
            return this.timestamp;
        }

        @Override
        public boolean needsCaching() {
            return true;
        }

        @Override
        public boolean isNether() {
            return this.isNether;
        }

        @Override
        public Optional<LevelMetadata> getPins() {
            return Optional.ofNullable(this.pins);
        }

        public void setPins(LevelMetadata pins) {
            this.pins = pins;
        }

        public static WorldRegionFolder load(Path world, MinecraftDimension dimension, RegionRenderer renderer, boolean loadPins) throws IOException {
            WorldRegionFolder folder = WorldRegionFolder.load(world.resolve(dimension.getRegionPath()), renderer, dimension == MinecraftDimension.NETHER);
            if (loadPins) {
                folder.setPins(LevelMetadata.loadFromWorld(world, dimension));
            }
            return folder;
        }

        public static WorldRegionFolder load(Path regionFolder, RegionRenderer renderer, boolean isNether) throws IOException {
            HashMap<Vector2ic, Path> files = new HashMap<Vector2ic, Path>();
            try (Stream<Path> stream = Files.list(regionFolder);){
                for (Path p : stream::iterator) {
                    Matcher m = rfpat.matcher(p.getFileName().toString());
                    if (!m.matches()) continue;
                    files.put(new Vector2i(Integer.parseInt(m.group(1)), Integer.parseInt(m.group(2))), p);
                }
            }
            return new WorldRegionFolder(files, renderer, isNether);
        }
    }
}

